<?php
/**
 * Postbit Layout Per Theme
 * Copyright 2011 Aries-Belgium
 *
 * $Id$
 */

// Disallow direct access to this file for security reasons
if(!defined("IN_MYBB"))
{
	die("Direct initialization of this file is not allowed.<br /><br />Please make sure IN_MYBB is defined.");
}

$plugins->add_hook('showthread_start', 'postlayouttheme_force', 100);
$plugins->add_hook('admin_formcontainer_output_row', 'postlayouttheme_output_row');
$plugins->add_hook('admin_style_themes_edit_commit', 'postlayouttheme_save_theme');

/**
 * Info function for MyBB plugin system
 */
function postlayouttheme_info()
{
	$donate_button = 
'<a href="https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=RQNL345SN45DS" style="float:right;margin-top:-8px;padding:4px;" target="_blank"><img src="https://www.paypalobjects.com/WEBSCR-640-20110306-1/en_US/i/btn/btn_donate_SM.gif" /></a>';

	return array(
		"name"			=> "هاك تغيير شكل مربع البوست بت",
		"description"	=> $donate_button."يسمح لك بتغيير شكل البوست بت ويظهر بشكل منظم",
		"website"		=> "",
		"author"		=> "Aries-Belgium",
		"authorsite"	=> "http://community.mybb.com/user-3840.html",
		"version"		=> "1.1",
		"guid" 			=> "69b2d5d81ed385b53a13c0358fe81e62",
		"compatibility" => "16*"
	);
}

/**
 * The install function for the MyBB plugin system
 */
function postlayouttheme_install()
{
	global $db;
	$db->query("ALTER TABLE  ".TABLE_PREFIX."themes ADD  `postlayout` VARCHAR( 15 ) NOT NULL");
}

/**
 * The is_installed function for the MyBB plugin system
 */
function postlayouttheme_is_installed()
{
	global $db;
	return $db->field_exists("postlayout", "themes");
}

/**
 * The install function for the MyBB plugin system
 */
function postlayouttheme_uninstall()
{
	global $db;
	
	$db->query("ALTER TABLE  ".TABLE_PREFIX."themes DROP  `postlayout`");
}

/**
 * Implementation of the showthread_start hook
 *
 * Force to use the default layout style
 */
function postlayouttheme_force()
{
	global $mybb, $db, $theme;
	
	$query = $db->simple_select("themes", "postlayout", "tid='{$theme['tid']}'");
	$postlayout = $db->fetch_field($query, "postlayout");
	switch($postlayout)
	{
		case 'horizontal':
			$mybb->settings['postlayout'] = 'horizontal';
			$mybb->user['classicpostbit'] = 0;
			break;
		case 'classic':
			$mybb->settings['postlayout'] = 'classic';
			$mybb->user['classicpostbit'] = 1;
			break;
	}
}

/**
 * Implementation of the admin_formcontainer_output_row hook
 * 
 * Show the settings for the postbit layout in the theme form
 */
function postlayouttheme_output_row($args)
{
	global $mybb;
	$module = $mybb->version_code >= 1600 ? 'style-themes' : 'style/themes';
	if($mybb->input['module'] == $module && $mybb->input['action'] == "edit" && $args['label_for'] == "imgdir")
	{
		global $form, $theme;
		
		$form_container = $args['this'];
		$form_container->output_row(
			"مظهر البوست بت",
			"تغيير شكل مربع البوست بت",
			$form->generate_select_box(
				'postlayout',
				array(
					'default' => "الافتراضي",
					'horizontal' => "افقي",
					'classic' => "كلاسيك"
				),
				$theme['postlayout']
			),
			'postlayout'
		);
	}
}

/**
 * Implementation of the admin_style_themes_edit_commit hook
 * 
 * When the theme gets saved, also save the postbit layout
 */
function postlayouttheme_save_theme()
{
	global $mybb, $theme, $db;
	
	if(isset($mybb->input['postlayout']))
	{
		$postlayout = $db->escape_string($mybb->input['postlayout']);
		$db->update_query("themes", array('postlayout' => $postlayout), "tid='{$theme['tid']}'");
	}
}